# implementation of the PBT/PB2/PB2-Mixer Baselines
from hpo.casmo.bgpbt import BGPBT


class PBT(BGPBT):
    """The original population based training without the surrogate model. Relies only on random sampling"""

    def explore(self, agent, best_agent):
        dfnewpoint, data, agent_t = self.format_df(agent, best_agent)
        new_config = self.env.config_space.sample_configuration()
        to_use = new_config.get_array().tolist()
        try:
            self.running[str(agent_t)].update({str(agent): to_use})
        except KeyError:
            self.running.update({str(agent_t): {str(agent): to_use}})

        return new_config
